import inspect
import time
import csv
from datetime import datetime
import socket
from fleming.hta.myNumPy import varName

async def test():
    if not hasattr(test,"counter"):
        test.counter=0
    test.counter+=1
    return test.counter

# adaptor function to call functions in sequence
# async def adaptor(comment="commenting", file="test.csv", header=True, prefuncs=[], funcs=[], repeat=1, postfuncs=[]): # return must be list or iterable. 
# comment: information in the output file
# file: filename, the autogenerated file has some format and information from prefuncs
# header: if geneate header or not, True (default) or False
# prefuncs, funcs, repeat, postfuncs: The following functions are the sequences: defined as prefuncs + funcs x repeat + postfuncs
# Note: all funtion return shuold be either dict or list.
# exaample:
# prefuncs=[[lum_init],[moveFocus,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
# funcs=[[kaleido_lum,1000],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
# postfuncs=[]  
# await adaptor(comment ="comment_testing", file="test.csv", header=True, prefuncs, funcs, postfuncs)
# 
async def adaptor(comment="commenting", file="test.csv", header=True, prefuncs=[], funcs=[], repeat=1, postfuncs=[]): # return must be list or iterable. 
    # precall function header
    if header:
        with open(file,'a') as f:
            f.write(f"{comment}:{socket.gethostname()}\n")
            f.write(f"precalled func:")
            writer=csv.writer(f, delimiter=';', dialect='excel-tab')
            h = await header_Gen(prefuncs)
            f.write(h+"\n")
    else:
        await header_Gen(prefuncs)    
    
    counter=0
    # actual core functions with or without header
    with open(file,'a') as f:
        writer=csv.writer(f, delimiter='\t', dialect='excel-tab')
        for i in range(repeat):
            if (i==0) & (header):
                output,h,info=await header_output_Gen(funcs,True)
                f.write(info+"\n")
                f.write("time\t"+h+"\n")
            else:
                output=await header_output_Gen(funcs)
            # print(output)
            if len(output)>0:
                tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
                writer.writerows([list([tstr,*output])])
            print(counter)
            print(output)
            counter+=1

    # post functions for cleaning up
    for d in postfuncs:
        out = await d[0](*d[1:len(d)])

    print(f"done!:\t{inspect.stack()[0][3]}")
    return


# fleming.hta.call_function_sequence.header_gen
async def header_Gen(funcs=[],flagRunCode=True):
    print("haha")
    head=f""
    for d in funcs:
        if flagRunCode:
            if inspect.iscoroutinefunction(d[0]):
                out=await d[0](*d[1:len(d)])
            else:
                out=d[0](*d[1:len(d)])
                # out=await d[0](*d[1:len(d)])
        else:
            out=None
        # head+=f"{d[0].__name__}; "
        if inspect.ismethod(d[0]):
            vn=varName(d[0].__self__)
            print(vn)
            # vn=varName(d[0].__self__,5)
            # print(vn)
            if vn is None:
                head+="Instance."
            else:
                head+=vn+"."
            # head+=f"{d[0].__qualname__}; "
        head+=f"{d[0].__name__}; "
        if len(d)>1:
            head+="  ".join([f"{x}" for x in d[1:]])
        
        head+="; "
        
        if out is None:
            head+=";"
            continue
        elif type(out) is dict:
                out=" ".join([f"{k}@{out[k]}" for k in out.keys()])
                head += out
        # elif type(out) is int:
        #     head += f" {out}"
        # elif  type(out) is float:
        #     print(len(out))
        #     print(type(out))
        #     head += f" {out:5.3f};"
        else:
            head+="  ".join([f"{x}" for x in out])
            head+=";"
            
    print(head)
    return head

# fleming.hta.call_function_sequence.header_output_Gen
# async def header_output_Gen(funcs=[[kaleido_lum,100],[pmt_exposure,1]],header=False):
async def header_output_Gen(funcs=[[test]],header=False):
    head=f""  # string of the function names and out_0, ...
    info=f""  # string of the function names and the arguments, ...
    output=[]

    for d in funcs:
        if inspect.iscoroutinefunction(d[0]):
        # if inspect.iscoroutinefunction(d):
            out=await d[0](*d[1:len(d)])
        else:
            out=d[0](*d[1:len(d)])
        # out=await d[0](*d[1:len(d)])
        if out is None:
            continue

        if header:
            if type(out) is dict:
                # key=[k for k in out.keys()]
                head+="\t".join([f"{x}" for x in out.keys()])
                head+="\t"
            else:  # todo: when it is a class. get the props
                head+=f"{d[0].__name__}_"
                head+="\t".join([f"out_{x}" for x in range(0,len(out))])
                head+="\t"
            
            info+=f"{d[0].__name__}; "
            if len(d)>1:
                info+="  ".join([f"{x}" for x in d[1:]])
            info+="; "

        if not (out is None):
            if not(type(out) is dict):
                output+=out
            else:
                out=[k for k in out.values()]
                output += out

    print(head,info)
    if header:
        return output, head, info
    else:
        return output
    
    
def reload():
    pass